/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.server.VWSecurityQueryResults;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class VWSecurityList
implements Serializable {
    private static final long serialVersionUID = 7491L;
    protected static final int LIST_USER = 1;
    protected static final int LIST_GROUP = 2;
    protected static final int LIST_USER_AND_GROUP = 3;
    protected static final String DELIM = String.valueOf(":");
    protected int bufferSize = 200;
    protected String[] fetchedObjects = null;
    protected Long[] idList = null;
    protected int returnCount = 0;
    protected int fetchCount = 0;
    protected boolean queryIsOver = false;
    protected String lastRecord = null;
    protected int listNameType = 0;
    protected VWSession session = null;
    protected Hashtable allUsers = null;
    protected String NCHServerName = null;
    protected String NCHServerDomain = null;
    protected String NCHServerOrganization = null;
    protected String searchPattern = null;
    protected String domain = null;
    protected int searchType = 0;
    protected int sortType = 0;
    protected long rpcArgFlag = 0L;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-23 21:59:27 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWSecurityList(VWSession theSession, int theBufferSize, int theListNameType) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.listNameType = theListNameType;
        this.hasNext();
    }

    protected VWSecurityList(VWSession theSession, int theBufferSize, int theListNameType, String theSearchPattern, String theDomain, int theSearchType, int theSortType, long theRpcArgFlag) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.listNameType = theListNameType;
        this.searchPattern = theSearchPattern;
        this.domain = theDomain;
        this.searchType = theSearchType;
        this.sortType = theSortType;
        this.rpcArgFlag = theRpcArgFlag;
        this.hasNext();
    }

    protected VWSecurityList(VWSession theSession, int theBufferSize, int theListNameType, String name, long secid, String theSearchPattern, String theDomain, int theSearchType, int theSortType, long theRpcArgFlag) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.listNameType = theListNameType;
        this.searchPattern = theSearchPattern;
        this.domain = theDomain;
        this.allUsers = new Hashtable(1);
        this.allUsers.put(new Long(secid), name);
        this.fetchCount = 1;
        this.searchType = theSearchType;
        this.sortType = theSortType;
        this.rpcArgFlag = theRpcArgFlag;
        this.hasNext();
    }

    protected VWSecurityList(VWSession theSession, int theBufferSize, int theListNameType, String name, long secid, String theSearchPattern, String theDomain, int theSearchType, int theSortType, long theRpcArgFlag, boolean prefetch) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.listNameType = theListNameType;
        this.searchPattern = theSearchPattern;
        this.domain = theDomain;
        this.allUsers = new Hashtable(1);
        this.allUsers.put(new Long(secid), name);
        this.fetchCount = 1;
        this.searchType = theSearchType;
        this.sortType = theSortType;
        this.rpcArgFlag = theRpcArgFlag;
        if (prefetch) {
            this.hasNext();
        }
    }

    public void resetFetch() {
        this.queryIsOver = false;
        this.lastRecord = null;
        this.fetchedObjects = null;
        this.returnCount = 0;
        this.fetchCount = 0;
    }

    public Object next() throws VWException {
        String result = null;
        if (this.fetchCount == this.returnCount) {
            this.dofetch();
        }
        if (this.fetchCount != 0) {
            result = this.fetchedObjects[this.returnCount];
            ++this.returnCount;
        }
        return result;
    }

    protected void dofetch() throws VWException {
        if (this.fetchCount == this.returnCount) {
            this.returnCount = 0;
            this.fetchCount = 0;
            if (!this.queryIsOver) {
                VWSecurityQueryResults qresult;
                this.session.checkSession();
                if (this.NCHServerName == null) {
                    this.getNCHServerValues();
                }
                if ((qresult = this.session.getCmdSession().fetchUserList(this.bufferSize, this.listNameType, this.lastRecord, this.searchPattern, this.domain, this.searchType, this.sortType, this.rpcArgFlag)) != null) {
                    if (qresult.fetchedObjects != null) {
                        this.fetchedObjects = new String[qresult.fetchedObjects.length];
                        for (int i = 0; i < qresult.fetchedObjects.length; ++i) {
                            this.fetchedObjects[i] = this.session.getCmdSession().getSecurityType() < 1 ? this.session.stripOrgAndDomain(qresult.fetchedObjects[i].getParticipantName()) : qresult.fetchedObjects[i].getParticipantName();
                        }
                    }
                    this.lastRecord = qresult.lastRecord;
                    this.queryIsOver = qresult.queryIsOver;
                    this.idList = qresult.idList;
                }
            }
            if (this.fetchedObjects != null) {
                this.fetchCount = this.fetchedObjects.length;
            }
        }
    }

    public boolean hasNext() throws VWException {
        boolean result = true;
        if (!(this.queryIsOver || this.fetchCount != 0 && this.returnCount != this.fetchCount)) {
            this.dofetch();
        }
        if (this.queryIsOver && this.returnCount == this.fetchCount) {
            result = false;
        }
        return result;
    }

    protected String findName(Long id) throws VWException {
        String result = null;
        try {
            if (this.allUsers != null) {
                result = (String)this.allUsers.get(id);
            }
            if (result == null) {
                Long[] ids = new Long[]{id};
                VWParticipant[] participants = this.session.getCmdSession().convertSecurityIdstoNames(ids);
                String theName = null;
                if (ids != null) {
                    for (int j = 0; j < participants.length; ++j) {
                        theName = this.session.stripOrgAndDomain(participants[j].getParticipantName());
                        this.allUsers.put(ids[j], theName);
                        ++this.fetchCount;
                        result = theName;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.api.SLFindNameException", "Exception trying to find name:{0} {1}", id, ex.getMessage());
        }
        return result;
    }

    protected Long findId(String name, boolean useCase) throws VWException {
        Long result = null;
        try {
            if (this.allUsers != null) {
                Enumeration theIds = this.allUsers.keys();
                int nameCount = this.allUsers.size();
                String aName = null;
                Long aId = null;
                String theName = this.session.stripOrgAndDomain(name);
                for (int i = 0; i < nameCount; ++i) {
                    if (!theIds.hasMoreElements()) continue;
                    aId = (Long)theIds.nextElement();
                    aName = (String)this.allUsers.get(aId);
                    if (useCase) {
                        if (!theName.equals(aName)) continue;
                        result = aId;
                        break;
                    }
                    if (!theName.equalsIgnoreCase(aName)) continue;
                    result = aId;
                    break;
                }
            }
            if (result == null) {
                String[] names = new String[]{name};
                Long[] ids = this.session.getCmdSession().convertSecurityNamestoIds(names, true);
                String theName = null;
                if (ids != null) {
                    for (int j = 0; j < ids.length; ++j) {
                        theName = this.session.stripOrgAndDomain(names[j]);
                        this.allUsers.put(ids[j], theName);
                        ++this.fetchCount;
                        result = ids[j];
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.api.SLFindIdException", "Exception trying to find id:{0} {1}", name, ex.getMessage());
        }
        return result;
    }

    protected Long findLDAPId(String name, boolean useCase) throws VWException {
        Long result = null;
        try {
            if (this.allUsers != null) {
                Enumeration theIds = this.allUsers.keys();
                int nameCount = this.allUsers.size();
                String aName = null;
                Long aId = null;
                for (int i = 0; i < nameCount; ++i) {
                    if (!theIds.hasMoreElements()) continue;
                    aId = (Long)theIds.nextElement();
                    aName = (String)this.allUsers.get(aId);
                    if (useCase) {
                        if (!name.equals(aName)) continue;
                        result = aId;
                        break;
                    }
                    if (!name.equalsIgnoreCase(aName)) continue;
                    result = aId;
                    break;
                }
            }
            if (result == null) {
                String[] names = new String[]{name};
                Long[] ids = this.session.getCmdSession().convertSecurityNamestoIds(names, true);
                if (ids != null) {
                    for (int j = 0; j < ids.length; ++j) {
                        if (ids[j] != 9L) {
                            this.allUsers.put(ids[j], names[j]);
                            ++this.fetchCount;
                        }
                        result = ids[j];
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.api.SLFindIdException", "Exception trying to find id:{0} {1}", name, ex.getMessage());
        }
        return result;
    }

    protected String findLDAPName(Long id) throws VWException {
        String result = null;
        try {
            if (this.allUsers != null) {
                result = (String)this.allUsers.get(id);
            }
            if (result == null) {
                Long[] ids = new Long[]{id};
                VWParticipant[] participants = this.session.getCmdSession().convertSecurityIdstoNames(ids);
                if (ids != null) {
                    for (int j = 0; j < participants.length; ++j) {
                        if (ids[j] != 9L) {
                            this.allUsers.put(ids[j], participants[j].getParticipantName());
                            ++this.fetchCount;
                        }
                        result = participants[j].getParticipantName();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.api.SLFindNameException", "Exception trying to find name:{0} {1}", id, ex.getMessage());
        }
        return result;
    }

    protected Hashtable getAllUsers() throws VWException {
        this.allUsers = null;
        this.allUsers = new Hashtable(2);
        this.resetFetch();
        this.listNameType = 3;
        int cnt = 0;
        while (!this.queryIsOver) {
            this.returnCount = this.fetchCount;
            this.next();
            for (int i = cnt; i < this.idList.length + cnt; ++i) {
                this.allUsers.put(this.idList[i - cnt], this.fetchedObjects[i - cnt]);
            }
            cnt = this.idList.length + cnt;
        }
        return this.allUsers;
    }

    protected void getNCHServerValues() throws VWException {
        try {
            StringTokenizer stmp;
            if (this.NCHServerName == null) {
                this.NCHServerName = this.session.getNCHServerName();
            }
            if (this.NCHServerName != null && (stmp = new StringTokenizer(this.NCHServerName, DELIM, false)).hasMoreTokens()) {
                String tmpName = stmp.nextToken();
                if (stmp.hasMoreTokens()) {
                    this.NCHServerDomain = stmp.nextToken();
                    if (stmp.hasMoreTokens()) {
                        this.NCHServerOrganization = stmp.nextToken();
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof VWException) {
                throw (VWException)ex;
            }
            this.NCHServerName = null;
            this.NCHServerDomain = "FileNetDomain";
            this.NCHServerOrganization = "FileNet";
            return;
        }
    }

    public String toString() {
        String theString = "";
        String separator = ",";
        if (this.fetchedObjects != null && this.fetchedObjects.length > 0) {
            theString = this.fetchedObjects[0];
            for (int i = 1; i < this.fetchedObjects.length; ++i) {
                theString = theString + separator + this.fetchedObjects[i];
            }
        } else {
            theString = null;
        }
        return theString;
    }
}

